$(function(){


	$(document).on('click','a[href="#open_dir_structure"]',function(){
			var THIS = this;
			if($(this).data('load')){
				$(THIS).parent().children('table').toggle();
			}else{
				$.get('/projects/'+$(this).data('project_id')+'/structure/',{
					'level':$(this).data('level'),
					'path':$(this).data('path'),
					'ajax':1
				},function(res){
	      	$(THIS).parent().append(res);
	      	$(THIS).data('load',true);
	      	$(THIS).attr('data-load','true');
				});
			}
		return false;
	});
	  
	$(document).on('click','a[href="#delete_project"]',function(){
		if(confirm('Вы точно хотите удалить проект?')){
			$.get('/ajax/delete_project/',{
				'id':$(this).data('project_id')
			},function(res){
					if(res.status=="ok"){
						location.reload();
					}else{
						MyCMSDialog.open({'type':'default','maxwidth':'400','maxheight':'200',"content":res.msg});
					}
			},'json');
		}
		return false;
	});
	
	$(document).on('click','a[href="#precheck"]',function(){
		$.post('/ajax/precheck/',{
			'project_id':$(this).data('project_id')
		},function(res){
				if(res.status=="ok"){
					location.reload();
				}else{
					MyCMSDialog.open({'type':'default','maxwidth':'400','maxheight':'200',"content":res.msg});
				}
		},'json');
		return false;
	});
	
	$(document).on('click','a[href="#verified_error"]',function(){
		$.post('/ajax/verified/',{
			'type':'error',
			'project_id':$(this).data('project_id')
		},function(res){
				if(res.status=="ok"){
					location.reload();
				}else{
					MyCMSDialog.open({'type':'default','maxwidth':'400','maxheight':'200',"content":res.msg});
				}
		},'json');
		return false;
	});
	
	$(document).on('click','a[href="#verified_warning"]',function(){
		var THIS = this;

		$.post('/ajax/verified/',{
			'type':'warning',
			'project_id':$(this).data('project_id'),
			'scan_id':$(this).data('scan_id'),
		},function(res){
				if(res.status=="ok"){
					$(THIS).before('✓');
					$(THIS).remove();
					//location.reload();
				}else{
					MyCMSDialog.open({'type':'default','maxwidth':'400','maxheight':'200',"content":res.msg});
				}
		},'json');
		return false;
	});
	
	$(document).on('click','a[href="#loginfoAll"]',function(){
		$('a[href="#loginfo"]').not('.__open').click();
		return false;
	});
	$(document).on('click','a[href="#loginfoNew"]',function(){
		$('a[href="#loginfo"].__new-event').not('.__open').click();
		return false;
	});
	
	$(document).on('click','a[href="#verified_open_ok"]',function(){
		var block = $(this).data('log_page') ? $('body') : $(this).parent();

		if($('a[href="#loginfo"].__open',block).size()>0){
			if(confirm('Вы уверены, что хотите утвердить все изменения сразу?')){
				var project_id = $(this).data('project_id');
				var logIds = [];
				var i = 0;

				$('a[href="#loginfo"].__open',block).each(function(){
					var tbody = $(this).closest('tbody');
					if($(tbody).data('scan_id')>0){
						logIds[i] = $(tbody).data('scan_id');
						i++;
						if( $('a[href="#verified_warning"]',tbody).size()>0 ){
							$('a[href="#verified_warning"]',tbody).before('✓');
							$('a[href="#verified_warning"]',tbody).remove();
						} else if( $('a[href="#verified_error"]',tbody).size()>0 ){
							$('a[href="#verified_error"]',tbody).before('✓');
							$('a[href="#verified_error"]',tbody).remove();
						}
					}
				});
				if(i>0){
					$.post('/ajax/verified/',{
						'project_id':project_id,
						'scan_id':logIds,
					},function(res){
							if(res.status!="ok"){
								MyCMSDialog.open({'type':'default','maxwidth':'400','maxheight':'200',"content":res.msg});
							}
					},'json');
				}
			}
		}else{
			alert('Разверните!');
		}
		return false;
	});	
	
	$(document).on('click','a[href="#loginfo"]',function(){
		var tbody = $(this).closest('tbody');
		if($(this).data('load')){
			return false;
		}
		$(this).data('load',true);
		$('*[data-id="loginfo"]',tbody).html('<p>загрузка...</p>');
		$.get('/ajax/loginfo/',{
			'project_id':$(this).data('project_id'),
			'scan_id':$(this).data('scan_id'),
		},function(res){
			$('*[data-id="loginfo"]',tbody).html(res.msg);
		},'json');
		return false;
	});
 	
	$('a[href="#edit_project"]').click(function(){
 		var id = $(this).data('id');
 		$.get('/ajax/project/',{'id':id},function(html){
			MyCMSDialog.open({'type':'default','maxwidth':'800',"content":html});
			inputStyler('checkbox');
			inputStyler('radio'); 
			$('select').each(function(){
				var multiple = $(this).attr('multiple') ? true : false;
				var noneSelectedText = $(this).data('text');
				$(this).multiselect({
					multiple: multiple,
					checkAllText: 'Выбрать все',
					uncheckAllText: 'Удалить все',
					noneSelectedText: noneSelectedText,
					selectedText: '# выбрано',
					selectedList: 3,
					height: 234
				});
			});
		});
		return false; 
 	});
 	
	 $('a[href="#profile"]').click(function(){
 		var id = $(this).data('id');
 		$.get('/ajax/profile/',{'id':id},function(html){
			MyCMSDialog.open({'type':'default','maxwidth':'400','maxheight':'300',"content":html}); 
		});
		return false; 
 	});
	 
	 $('a[href="#edit_user"]').click(function(){
 		var id = $(this).data('id');
 		$.get('/ajax/user/',{'id':id},function(html){
			MyCMSDialog.open({'type':'default','maxwidth':'800','maxheight':'500',"content":html}); 
		});
		return false; 
 	});
 	
 	$('a[href="#delete_user"]').click(function(){
 		var id = $(this).data('id');
 		if(confirm('Вы точно хотите удалить пользователя?')){
			 $.post('/ajax/delete_user/',{'id':id},function(res){
				if(res.status=="ok"){
					location.href="/users/";
				}else{
					MyCMSDialog.open({'type':'default','maxwidth':'400','maxheight':'200',"content":res.msg});
				}
			},'json');
		}
		return false; 
 	});
 
	$(document).on('submit','form[name="user"]',function(){
		$.post('/ajax/save_user/',$(this).serialize(),function(res){
			if(res.status=="ok"){
				location.href="/users/";
			}else{
				MyCMSDialog.open({'type':'default','maxwidth':'400','maxheight':'200',"content":res.msg});
			}
		},'json');
		return false;
	});
	
	$('form[name="password_save"]').submit(function(){
		$.post('/ajax/password_save/',$(this).serialize(),function(res){
			if(res.status=="ok"){
				MyCMSDialog.closeAll();
				MyCMSDialog.open({'type':'default','maxwidth':'400','maxheight':'200',"content":res.msg});
			}else{
				MyCMSDialog.open({'type':'default','maxwidth':'400','maxheight':'200',"content":res.msg});
			}
		},'json');
		return false;
	});
	
	$(document).on('submit','form[name="project"]',function(){
		$.post('/ajax/save_project/',$(this).serialize(),function(res){
			if(res.status=="ok"){
				location.reload();
			}else{
				MyCMSDialog.open({'type':'default','maxwidth':'400','maxheight':'200',"content":res.msg});
			}
		},'json');
		return false;
	});
	
	$(document).on('click','a[href="#download"]',function(){
		MyCMSDialog.open({'type':'default','width':500,'height':200,"title":'Получить PHP-файл',"content":'<center><a href="/projects/'+$(this).data('project_id')+'/download/?src=1" target="_iframe" onclick="MyCMSDialog.closeAll();">В открытом коде</a> | <a target="_iframe" onclick="MyCMSDialog.closeAll();" href="/projects/'+$(this).data('project_id')+'/download/">Обфусцированный файл</a></center>'});
		return false;
	});
	
	$(document).on('click','a[href="#test"]',function(){
		MyCMSDialog.open({'type':'default','width':500,'height':200,"title":'',"content":'<center><a href="#test_fast" data-id="'+$(this).data('id')+'">Проверка установки сканера</a> | <a href="#test_full" data-id="'+$(this).data('id')+'">Проверка работы сканера</a></center>'});

		return false;
	});

	$(document).on('click','a[href="#test_fast"]',function(){
    MyCMSDialog.closeAll();
		MyCMSDialog.open({'type':'default','width':300,'height':200,"content":'<center><img src="/skin/images/ajax.gif"> Тестируем...<br> Проверка установки сканера</center>'});
		$.get('/ajax/test/',{'id':$(this).data('id'),'type':'fast'},function(res){
			MyCMSDialog.closeAll();
			if(res.status=="ok"){
				MyCMSDialog.open({'type':'default','title':'Тестирование прошло успешно',"content":res.msg,'maxwidth':640,'maxheight':'520'});
			}else{
				MyCMSDialog.open({'type':'default','maxwidth':'500','maxheight':'300','title':'Ошибка!',"content":res.msg});
			}
		},'json');
		return false;
	});
	
	$(document).on('click','a[href="#test_full"]',function(){
    MyCMSDialog.closeAll();
		MyCMSDialog.open({'type':'default','width':300,'height':200,"content":'<center><img src="/skin/images/ajax.gif"> Тестируем...<br> Проверка работы сканера</center>'});
		$.get('/ajax/test/',{'id':$(this).data('id'),'type':'all'},function(res){
			MyCMSDialog.closeAll();
			if(res.status=="ok"){
				MyCMSDialog.open({'type':'default','title':'Тестирование прошло успешно',"content":res.msg,'maxwidth':640,'maxheight':'520'});
			}else{
				MyCMSDialog.open({'type':'default','maxwidth':'500','maxheight':'300','title':'Ошибка!',"content":res.msg});
			}
		},'json');
		return false;
	});


	$('#layout_body').addClass('transition');

	$('.open-dialog').MyCMSDialog();

	$('.phone-mask').mask("+7 (999) 999-99-99");

	inputStyler('checkbox');
	inputStyler('radio');
	inputStyler('file');

	$('select').each(function(){
		var multiple = $(this).attr('multiple') ? true : false;
		var noneSelectedText = $(this).data('text');
		$(this).multiselect({
			multiple: multiple,
			checkAllText: 'Выбрать все',
			uncheckAllText: 'Удалить все',
			noneSelectedText: noneSelectedText,
			selectedText: '# выбрано',
			selectedList: 3,
			height: 234
		});
	});

	$('#search').submit(function(){
		var q = $(this).find('input[name="q"]').val();
		if($.trim(q)==""){
			$(this).find('input[name="q"]').focus();
			return false;
		}
	});

	$('body').on('click', '.tooltip_btn', function(){
		var $this = $(this);
		var $tgglBlock = $this.next('.tooltip_content');
		var positionB = $(window).height() - $this.offset().top + $this.outerHeight() - $('body').scrollTop();
		if ($this.hasClass('__ac')) { 
			$this.removeClass('__ac __drop-t');
		} else {
			$('.tooltip_btn').removeClass('__ac __drop-t');
			$this.addClass('__ac');
			if (positionB < $tgglBlock.outerHeight()) {
				$this.addClass('__drop-t');
			}
		}
		console.log(positionB);
		console.log($tgglBlock.outerHeight());
		return false;
	});
	
	$(document).click(function(e){
		if($(e.target).closest(".tooltip_btn").hasClass('__ac')) return;
		$('.tooltip_btn').removeClass('__ac __drop-t');
		e.stopPropagation();
	});

	$('body').on('click', '.tggl-btn', function(){
		var $this = $(this);
		var $tgglBlock = $this.closest('tbody').children('.tggl-block');
		if ($this.hasClass('__open')) { 
			$this.removeClass('__open').text('Развернуть');
			$tgglBlock.addClass('hidden');
		} else {
			$this.addClass('__open').text('Свернуть');
			$tgglBlock.removeClass('hidden');
		}
		//return false;
	});

	$('input.checkall').click(function(){
		$('input[type="checkbox"][rel="'+$(this).attr('rel')+'"]').not(':disabled').not($(this)).trigger('click');
		$(this).attr({'disabled':true});
	});

});

function inputStyler(inpType) {
	$('input[type="'+inpType+'"]').each(function(){
		if (inpType=="file") {
			var inp = $(this),
				wrapper = inp.parent('.file-upload'),
				lbl = wrapper.find('.file-upload_mark');

			inp.focus(function(){
				wrapper.addClass('focus');
			}).blur(function(){
				wrapper.removeClass('focus');
			});

			var file_api = ( window.File && window.FileReader && window.FileList && window.Blob ) ? true : false;

			inp.change(function(){
				var file_name;
				if( file_api && inp[ 0 ].files[ 0 ] )
					file_name = inp[ 0 ].files[ 0 ].name;
				else
					file_name = inp.val().replace( "C:\\fakepath\\", '' );

				if( ! file_name.length )
					return;

				lbl.text( file_name).addClass('__ac');

			}).change();

		} else {
			if (!$(this).hasClass('no-style')) $(this).wrap('<span class="switch-wrap __' + inpType + '">').after('<span class="switch">');
		}
	});
};