<?
function _filesize($size=0){
  if($size>0){
    $FS = array("B","kB","MB","GB","TB","PB","EB","ZB","YB");
    return number_format($size/pow(1024, $I=floor(log($size, 1024))), ($I >= 1) ? 2 : 0) . ' ' . $FS[$I];
  }else{
    return "-";
  }
}

function generate_password($number){
    $arr = array('a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','r','s','t','u','v','x','y','z','A','B','C','D','E','F',
                 'G','H','I','J','K','L','M','N','O','P','R','S','T','U','V','X','Y','Z','1','2','3','4','5','6','7','8','9','0');
    $pass = "";
    for($i = 0; $i < $number; $i++){
      $index = rand(0, count($arr) - 1);
      $pass .= $arr[$index];
    }
    return $pass;
}

function sendEmail($email,$Subject,$Body,$From=false,$FromName=false){
	global $config;
    Serval::call('phpmailer')->IsMail();
    Serval::call('phpmailer')->Subject    = $Subject;
    Serval::call('phpmailer')->FromName   = $FromName ? $FromName : $config['domain']; 
    Serval::call('phpmailer')->From       = $From ? $From : 'noreply@'.$config['domain']; 
    Serval::call('phpmailer')->CharSet    = "utf-8";
    Serval::call('phpmailer')->WordWrap   = 75;
    Serval::call('phpmailer')->IsHTML(true);
    Serval::call('phpmailer')->Body = $Body;
    Serval::call('phpmailer')->AltBody = "";
    Serval::call('phpmailer')->AddAddress($email);
    
    $res = Serval::call('phpmailer')->Send();
    Serval::call('phpmailer')->ClearAddresses();
    Serval::call('phpmailer')->ClearAllRecipients();
    return $res;
}

function escape($var='', $mode = ENT_COMPAT) {
    return htmlspecialchars($var, $mode);
}
function clearText($var='') {
    return trim(strip_tags($var));
}

function PagesList($current_page,$num,$count) {
  $current_page = (intval($current_page)) ? $current_page : 1;
  $page_num     = ceil($num/$count); 
  
  if($page_num>1){
      $out = array();
      //Предыдущая страница
      if ($current_page>1) {
          $out['back'] = array('page'=>$current_page-1,'url'=>(($current_page-1)<=1 ? '' : ($current_page-1)));
      }
      //Страницы
      for ($i = 1; $i < $page_num+1; $i++) {
          if ($i == $current_page) {
              $out['list'][] = array('page'=>$i,'current'=>1,'url'=>($i>1 ? $i : ''));
          }else{
            if ((($i > ($current_page - 4)) && ($i < ($current_page + 5))) OR ($i == $page_num) || ($i == 1)) {
              $out['list'][] =  array('page'=>$i,'url'=>($i>1 ? $i : ''));
            }    
          }
          if ($i < $page_num) {
              if (($current_page > 5) && ($i == 1))  $out['list'][] = array('dot'=>true);
              if (($current_page < ($page_num - 5)) && ($i == ($page_num - 1))) $out['list'][] =  array('dot'=>true);
          }
      }
      //Следующая страница
      if ($current_page<$page_num) {
          $out['next']=array('page'=>($current_page+1),'url'=>($current_page+1));
      }
      $out['count'] = $page_num;
    return $out;
  }else{
    return false;
  }
}

function imageResize($file, $savePath,$newWidth,$newHeight){
	
		$size = @getimagesize ($file);
		$img = false;
	  switch($size['mime']){
		   case 'image/jpeg':
			 case 'image/jpg':
					$img = @imagecreatefromjpeg($file);
	        $typeImage = 'jpg';
					break;
			 case 'image/gif':
					$img = @imagecreatefromgif($file);
	        $typeImage = 'gif';
					break;
			 case 'image/png':
					$img = @imagecreatefrompng($file);
	        $typeImage = 'png';
			 break;
			 default:
			 	return false;
		}
		
	  $width  = imagesx($img);
	  $height = imagesy($img);
		
		$heightRatio = $height / $newHeight;
		$widthRatio  = $width /  $newWidth;
		if($heightRatio < $widthRatio){
			$optimalRatio = $heightRatio;
		}else{
			$optimalRatio = $widthRatio;
		}
		$optimalHeight = $height / $optimalRatio;
		$optimalWidth  = $width  / $optimalRatio;
		
		$imageResized = imagecreatetruecolor($optimalWidth, $optimalHeight);
		
		switch($typeImage){
			case 'png':
		    imageAlphaBlending($imageResized, false);
		    imageSaveAlpha($imageResized, true);
			break;
			case 'gif':
	      $bgcolor = imagecolorallocate($this->imageResized, 255, 255, 255);
		    imagefill($imageResized, 0, 0, $bgcolor);
			break;
		}
	  imagecopyresampled($imageResized, $img, 0, 0, 0, 0, $optimalWidth, $optimalHeight, $width, $height);
					
		$cropStartX = ( $optimalWidth / 2) - ( $newWidth /2 );
		$cropStartY = ( $optimalHeight/ 2) - ( $newHeight/2 );
		$crop = $imageResized;
		$imageResized = imagecreatetruecolor($newWidth , $newHeight);
	  if($typeImage=="png"){
	    imageAlphaBlending($imageResized, false);
	    imageSaveAlpha($imageResized, true);
	  }
		imagecopyresampled($imageResized, $crop , 0, 0, $cropStartX, $cropStartY, $newWidth, $newHeight , $newWidth, $newHeight);
		$imageQuality = 100;
		$res = false;			
		switch($typeImage){
			case 'jpg':
				if(imagetypes() & IMG_JPG){
					$res = @imagejpeg($imageResized, $savePath, $imageQuality);   
				}
				break;
			case 'gif':
				if(imagetypes() & IMG_GIF){
					$res = @imagegif($imageResized, $savePath);
				}
				break;
			case 'png':  
				$scaleQuality = round(($imageQuality/100) * 1);
				$invertScaleQuality = 9 - $scaleQuality;
				if (imagetypes() & IMG_PNG) {         
					 $res = @imagepng($imageResized, $savePath, $invertScaleQuality);
				}
				break;
			default:
				break;
		}
		imagedestroy($imageResized);
	  return $res;

}

function strike_skip($str_in,$exc){
	if(is_array($exc) && count($exc)>0){
		foreach($exc as $str){
			$str = preg_quote("[{$str}]","#");
			$str = str_replace("\*","(.*)",$str);	
			if(preg_match("#^({$str})#","[".$str_in."]",$matches)){
				return true;
			}
		}
	}
	return false;
}

function prr($a){
	echo "<pre>";
	print_r($a);
	echo "</pre>";
}
?>